// LICENSE : MIT
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFormatterList = exports.createFormatter = exports.loadFormatter = exports.dynamicImport = void 0;
const module_interop_1 = require("@textlint/module-interop");
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
// @ts-expect-error
const try_resolve_1 = __importDefault(require("try-resolve"));
const debug_1 = __importDefault(require("debug"));
const node_url_1 = require("node:url");
// formatter
const checkstyle_1 = __importDefault(require("./formatters/checkstyle"));
const compact_1 = __importDefault(require("./formatters/compact"));
const jslint_xml_1 = __importDefault(require("./formatters/jslint-xml"));
const json_1 = __importDefault(require("./formatters/json"));
const junit_1 = __importDefault(require("./formatters/junit"));
const pretty_error_1 = __importDefault(require("./formatters/pretty-error"));
const stylish_1 = __importDefault(require("./formatters/stylish"));
const table_1 = __importDefault(require("./formatters/table"));
const tap_1 = __importDefault(require("./formatters/tap"));
const unix_1 = __importDefault(require("./formatters/unix"));
const builtinFormatterList = {
    checkstyle: checkstyle_1.default,
    compact: compact_1.default,
    "jslint-xml": jslint_xml_1.default,
    json: json_1.default,
    junit: junit_1.default,
    "pretty-error": pretty_error_1.default,
    stylish: stylish_1.default,
    table: table_1.default,
    tap: tap_1.default,
    unix: unix_1.default
};
const builtinFormatterNames = Object.keys(builtinFormatterList);
// import() can not load Window file path
// convert file path to file URL before import()
// https://github.com/nodejs/node/issues/31710
async function dynamicImport(targetPath) {
    const fileUrl = (0, node_url_1.pathToFileURL)(targetPath).href;
    return import(fileUrl);
}
exports.dynamicImport = dynamicImport;
const debug = (0, debug_1.default)("textlint:@textlint/linter-formatter");
async function loadFormatter(formatterConfig) {
    const formatterName = formatterConfig.formatterName;
    debug(`formatterName: ${formatterName}`);
    if (builtinFormatterNames.includes(formatterName)) {
        return {
            format(results) {
                return builtinFormatterList[formatterName](results, formatterConfig);
            }
        };
    }
    let formatter;
    let formatterPath;
    if (fs_1.default.existsSync(formatterName)) {
        formatterPath = formatterName;
    }
    else if (fs_1.default.existsSync(path_1.default.resolve(process.cwd(), formatterName))) {
        formatterPath = path_1.default.resolve(process.cwd(), formatterName);
    }
    else {
        const pkgPath = (0, try_resolve_1.default)(`textlint-formatter-${formatterName}`) || (0, try_resolve_1.default)(formatterName);
        if (pkgPath) {
            formatterPath = pkgPath;
        }
    }
    try {
        formatter = (0, module_interop_1.moduleInterop)((await dynamicImport(formatterPath)).default);
    }
    catch (ex) {
        throw new Error(`Could not find formatter ${formatterName}
${ex}`);
    }
    return {
        format(results) {
            return formatter(results, formatterConfig);
        }
    };
}
exports.loadFormatter = loadFormatter;
/**
 * @deprecated use loadFormatter
 * @param formatterConfig
 */
function createFormatter(formatterConfig) {
    const formatterName = formatterConfig.formatterName;
    debug(`formatterName: ${formatterName}`);
    if (builtinFormatterNames.includes(formatterName)) {
        return function (results) {
            return builtinFormatterList[formatterName](results, formatterConfig);
        };
    }
    let formatter;
    let formatterPath;
    if (fs_1.default.existsSync(formatterName)) {
        formatterPath = formatterName;
    }
    else if (fs_1.default.existsSync(path_1.default.resolve(process.cwd(), formatterName))) {
        formatterPath = path_1.default.resolve(process.cwd(), formatterName);
    }
    else {
        const pkgPath = (0, try_resolve_1.default)(`textlint-formatter-${formatterName}`) || (0, try_resolve_1.default)(formatterName);
        if (pkgPath) {
            formatterPath = pkgPath;
        }
    }
    try {
        formatter = (0, module_interop_1.moduleInterop)(require(formatterPath));
    }
    catch (ex) {
        throw new Error(`Could not find formatter ${formatterName}
${ex}`);
    }
    return function (results) {
        return formatter(results, formatterConfig);
    };
}
exports.createFormatter = createFormatter;
function getFormatterList() {
    return builtinFormatterNames.map((name) => {
        return {
            name
        };
    });
}
exports.getFormatterList = getFormatterList;
//# sourceMappingURL=index.js.map